//
// Vertex shader 

#version 120

uniform float frameTime;
uniform mat4 viewMatrixInverse;

varying vec3  normal;
varying vec3  eyeDir;

varying vec2 texCoord;



varying float time;

void main(void)
{
	
    gl_Position    = ftransform();
    normal         = normalize(gl_NormalMatrix * gl_Normal);
  
    vec4 pos       = gl_ModelViewMatrix * gl_Vertex;
    eyeDir         = vec3(viewMatrixInverse*vec4(pos.xyz,0));

    texCoord       = gl_MultiTexCoord0.xy;
	
	time           = 0.01 * frameTime;
}